/*  Animation maquette de locomotive - JLF : 18/01/2026    Fichier : Animaq_Arduino_JLF.ino

Site web : http://www.la-tour.info/uts/uts_page15.html

V1.0
V2.0 au 18/01/2026 : Nouvelle version avec le type de trame =[XYz]  : X = A,E,S,P   Y = F,J,R,C,P,T   y = 0,1,2,3

Pour allumer une led,  on envoie "[AYx]"                    Allume la led F=Feu, J=Projecteur, Rouge=Feu Rouge, C=cabine, P=Pantographe, x=0,1,2,3 = Numéro du voyant.
Pour éteindre une led, on envoie "[EYx]"                    Eteint la led.
Pour monter un pantographe, on envoie "[APx]"               Monte le pantographe n° x x=1,2.
Pour descendre un pantographe, on envoie "[EPx]"            Descend le pantographe n° x x=1,2.
Pour sélectionner la carte, on envoie "[S0x]"               Sélectionne la carte numéro x. 1 à 4.
Pour mettre tout en marche, on envoie "[ATx]"               Mise en marche de tout.
Pour mettre tout à l'arrêt, on envoie "[ETx]"               Mise à l'arrêt de tout.
Pour allumer les 4 feux blancs, on envoie "[AF4]"           Allume les 4 feux blancs.
Pour éteindre les 4 feux blancs, on envoie "[EF4]"          Eteint les 4 feux blancs.
Pour connaitre la version, on envoie "(V00)"                En retour, on reçoit : "JLF_V2.0_18/01/2026"

Les voyants à leds sont branchés entre les sorties et le + 5 Volts.
Un interrupteur branché sur la broche A4, permute les cabines 1 et 2.

Numéro à envoyer :
    [[1]] (1)    Proj.  Fanaux   Proj.    (2) [[2]]
           (1)         Feux rouges         (2)
                 (0)     Plafond     (1)
           (1)         Feux rouges         (3)
    [[0]] (0)    Proj.  Fanaux   Proj.    (3) [[3]]

On déclare le numéro de carte dans le code :
  const char adresse_carte = 0;  // Carte toujours sélectionnée.
  const char adresse_carte = 1;  // Adresse de carte = 1.
  const char adresse_carte = 2;  // Adresse de carte = 2.
  const char adresse_carte = 3;  // Adresse de carte = 3.
  const char adresse_carte = 4;  // Adresse de carte = 4.

Branchement :
                         ARDUINO NANO
             SIMU--<--TX1            VIN
             SIMU-->--RX0            GND
                    RESET        RESET
                      GND            +5V <-- 5 Volts
Feu blanc AR1         D02            A07
Feu blanc AV1         D03            A06
Feu blanc AV2         D04            A05
Projecteur blanc AV1  D05            A04  Interrupteur position cabine 1 / 2
Projecteur blanc AV2  D06            A03  Plafond AR
Projecteur blanc AR1  D07            A02  Feu rouge AR2
Projecteur blanc AR2  D08            A01  Feu rouge AR1
Servomoteur 1         D09            A00  Plafond AV1
Servomoteur 2         D10           VREF
Feu blanc AR2         D11           3,3V
Feu rouge AV1         D12            D13  Feu rouge AV2

On peut modifier ce programme et le diffuser. Dans ce cas, il faut préciser l'origine et donner accès aux sources modifiées.
Domaine : Informatique.
Définition : Un logiciel libre est un logiciel distribué avec l’intégralité de ses programmes-sources, afin que l’ensemble des utilisateurs qui l’emploient, puissent l’enrichir et le redistribuer à leur tour.
Note : Un logiciel libre n’est pas nécessairement gratuit et les droits de la chaîne des auteurs sont préservés.
Équivalent étranger : free software, open source software.
(Source : Vocabulaire de l’informatique (liste de termes, expressions et définitions adoptés), NOR: CTNX0710138K, J.O n° 93 du 20 avril 2007 page 7078, texte n° 84)
logiciel libre
Par logiciel libre on entend un logiciel qui offre la liberté aux utilisateurs d'exécuter, de copier, de distribuer, d'étudier, de modifier et d'améliorer le logiciel. Plus précisément, elle fait référence à quatre types de liberté pour les utilisateurs du logiciel :
    La liberté d'exécuter le programme, pour tous les usages (liberté 0).
    La liberté d'étudier comment le programme fonctionne et de l'adapter à ses besoins (liberté 1). L'accès au code source est une condition requise.
    La liberté de redistribuer des copies, (liberté 2).
    La liberté d'améliorer le programme et de diffuser les améliorations au public pour en faire profiter toute la communauté (liberté 3). L'accès au code source est une condition requise.
*********************/

#include <Servo.h>
// Adresse de la carte satellite. Carte toujours sélectionnée = 0, ou adresse_carte = 1 à 4.
const char adresse_carte = 0;  // Adresse de carte.

#define SORTIE_avant_rouge_1   12
#define SORTIE_avant_rouge_2   13
#define SORTIE_avant_plafond   A0
#define SORTIE_arriere_rouge_1 A1
#define SORTIE_arriere_rouge_2 A2
#define SORTIE_arriere_plafond A3

#define SORTIE_avant_blanc_1    3
#define SORTIE_avant_blanc_2    4
#define SORTIE_avant_proj_1     5
#define SORTIE_avant_proj_2     6
#define SORTIE_arriere_blanc_1  2
#define SORTIE_arriere_blanc_2 11
#define SORTIE_arriere_proj_1   7
#define SORTIE_arriere_proj_2   8
#define SORTIE_panto1           9
#define SORTIE_panto2          10

#define ENTREE_cabine_12       A4
//
//
// Variables à modifier suivant le montage
#define panto1_bas            600  // Position panto 1 - BAS  en µ sec.
#define panto1_haut          1950  // Position panto 1 - HAUT en µ sec.
#define panto2_bas            750  // Position panto 2 - BAS  en µ sec.
#define panto2_haut          2100  // Position panto 2 - HAUT en µ sec.

#define panto_pas              10  // xx µsec de pas unitaire. Minimum = 5 µsec, car les servomoteurs ne bougent pas si moins.
#define panto_vitesse          20  // xx msec entre chaque pas = Vitesse du panto. Minimum 20 msec.

int car_recu, i;
byte buffer_rx_cpt;                // Compteur de n° du caractère courant.
char car_lu;                       // Caractère lu.
char buffer_rx[10];                // Buffer de réception des caractères reçus.
int buffer_rx_valeur;              // Conversion du dernier champ : Ascii-> Entier.
boolean debut_rx;                  // Flag de début de réception,  true = indicateur de début de trame reçu.
boolean final_rx;                  // Flag de fin réception,       true = indicateur de fin de trame reçu.

byte carte_valide;                 // 0/1, 1 = carte sélectionnée.
byte x;
Servo servomoteur1;                // Déclaration servomoteurs
Servo servomoteur2;
int servo1_val, servo2_val;
int servo1_consigne, servo2_consigne;
unsigned long milli_actuel1, milli_actuel2; // Durée.
unsigned long milli_old1, milli_old2;       // Durée.
int num_cabine, num_cabine_old;             // Numéro de cabine = 1 ou 2.
unsigned long milli_cabine;                 // Durée.
//
// =========================================================================================================================
void setup() {
//=============================================================================================================================
// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
//=============================================================================================================================
  delay(200);
  pinMode(SORTIE_avant_rouge_1,   OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_avant_rouge_2,   OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_avant_plafond,   OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_rouge_1, OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_rouge_2, OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_plafond, OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_avant_blanc_1,   OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_avant_blanc_2,   OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_avant_proj_1,    OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_avant_proj_2,    OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_blanc_1, OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_blanc_2, OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_proj_1,  OUTPUT);   // Plot de sortie.
  pinMode(SORTIE_arriere_proj_2,  OUTPUT);   // Plot de sortie.
  pinMode(ENTREE_cabine_12,       INPUT);    // Plot d'entrée.

  Serial.begin(9600);                        // Vers le PC : 9600 / 19200 / 38400 bps.
  if (adresse_carte == 0) carte_valide = 1;  // Adresse = 0 => Carte sélectionnée.
  else carte_valide = 0;                     // Sinon, carte pas sélectionnée.

  digitalWrite(SORTIE_avant_blanc_1,   HIGH); digitalWrite(SORTIE_avant_blanc_2,   HIGH); digitalWrite(SORTIE_avant_proj_1,    HIGH);
  digitalWrite(SORTIE_avant_proj_2,    HIGH); digitalWrite(SORTIE_avant_rouge_1,   HIGH); digitalWrite(SORTIE_avant_rouge_2,   HIGH);
  digitalWrite(SORTIE_avant_plafond,   HIGH); digitalWrite(SORTIE_arriere_blanc_1, HIGH); digitalWrite(SORTIE_arriere_blanc_2, HIGH);
  digitalWrite(SORTIE_arriere_proj_1,  HIGH); digitalWrite(SORTIE_arriere_proj_2,  HIGH); digitalWrite(SORTIE_arriere_rouge_1, HIGH);
  digitalWrite(SORTIE_arriere_rouge_2, HIGH); digitalWrite(SORTIE_arriere_plafond, HIGH);
  servomoteur1.attach(SORTIE_panto1); servomoteur2.attach(SORTIE_panto2);
  servo1_val      = panto1_bas;  servo2_val      = panto2_bas;
  servo1_consigne = panto1_bas;  servo2_consigne = panto2_bas;
  servomoteur1.writeMicroseconds(servo1_consigne); servomoteur2.writeMicroseconds(servo2_consigne);
  milli_actuel1 = millis(); milli_actuel2 = millis(); milli_old1 = millis(); milli_old2 = millis();
  if (digitalRead(ENTREE_cabine_12) == 0) num_cabine = 1; else num_cabine = 2;
  milli_cabine = millis();
  buffer_rx_cpt = 0;                        // Compteur de n° du caractère courant.
  debut_rx = false;                         // Flag de début de réception d'une trame du PC.
  final_rx = false;                         // Flag de fin réception d'une trame du PC.
  buffer_rx[0] = '\0';
}

// =========================================================================================================================
void loop() {
//=============================================================================================================================
// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
//=============================================================================================================================
// Boucle principale.
//
  if (millis() > milli_cabine ) {
    milli_cabine = millis() + 200;  // On lit l'entrée digitale que toutes les 200 msec, pour eviter les rebonds.
    if (digitalRead(ENTREE_cabine_12) == 0) num_cabine = 1; else num_cabine = 2;  // Lecture interrupteur position des cabines 1 / 2.
    if (num_cabine != num_cabine_old) { // Si l'interrupteur a basculé, on change les lampes de place.
      i = digitalRead(SORTIE_avant_blanc_1); digitalWrite(SORTIE_avant_blanc_1, digitalRead(SORTIE_arriere_blanc_1)); digitalWrite(SORTIE_arriere_blanc_1, i);
      i = digitalRead(SORTIE_avant_blanc_2); digitalWrite(SORTIE_avant_blanc_2, digitalRead(SORTIE_arriere_blanc_2)); digitalWrite(SORTIE_arriere_blanc_2, i);
      i = digitalRead(SORTIE_avant_proj_1);  digitalWrite(SORTIE_avant_proj_1,  digitalRead(SORTIE_arriere_proj_1));  digitalWrite(SORTIE_arriere_proj_1, i);
      i = digitalRead(SORTIE_avant_proj_2);  digitalWrite(SORTIE_avant_proj_2,  digitalRead(SORTIE_arriere_proj_2));  digitalWrite(SORTIE_arriere_proj_2, i);
      i = digitalRead(SORTIE_avant_rouge_1); digitalWrite(SORTIE_avant_rouge_1, digitalRead(SORTIE_arriere_rouge_1)); digitalWrite(SORTIE_arriere_rouge_1, i);
      i = digitalRead(SORTIE_avant_rouge_2); digitalWrite(SORTIE_avant_rouge_2, digitalRead(SORTIE_arriere_rouge_2)); digitalWrite(SORTIE_arriere_rouge_2, i);
      i = digitalRead(SORTIE_avant_plafond); digitalWrite(SORTIE_avant_plafond, digitalRead(SORTIE_arriere_plafond)); digitalWrite(SORTIE_arriere_plafond, i);
      i = servo2_consigne;
      if   (servo1_consigne == panto1_haut) servo2_consigne = panto2_haut; else servo2_consigne = panto2_bas;
      if   (              i == panto2_haut) servo1_consigne = panto1_haut; else servo1_consigne = panto1_bas;
      num_cabine_old = num_cabine;
    }
  }

  while(Serial.available() > 0) {                              // Si l'on a reçu un caractère sur la liaisons série, on le lit.
    char car_lu = Serial.read();                               // La fonction 'Serial.read()' retourne un entier !  'car_lu' est déclaré en char.
    if(car_lu == '[') {                                        // On a reçu l'indicateur de début de trame '['.
      debut_rx = true;                                         // D'office, on initialise tout.
      final_rx = false;                                        // Indicateur de début de trame reçue = true, de fin de trame = false.
      buffer_rx_cpt = 0;                                       // Initialise compteur de caractères reçus.
      buffer_rx[0] = '\0';                                     // Initialise la chaine de caractères.
    }
    else if(car_lu == ']') {                                   // On a reçu l'indicateur de fin de trame ']'.
      if (debut_rx == true) {                                  // ON était bien en train de recevoir une trame.
        buffer_rx[buffer_rx_cpt] = '\0';                       // On écrit le caractère 'Null' pour finir la chaine de caractères.
        final_rx = true;                                       // On a bien reçu la trame, on valide la réception de fin de trame.
        break;                                                 // On sort de la boucle pour traiter cette trame complète, avant de traiter au prochain passage les autres caractères.
      }
      else { debut_rx = false; }                               // On a reçu l'indicateur de fin de trame, sans recevoir celui de début de trame et les 3 champs. On laisse tomber.
    }
    else if (debut_rx == true) {                               // On a déjà reçu l'indicateur de début de trame!
      buffer_rx[buffer_rx_cpt] = car_lu;                       // On a reçu un caractère qui n'est pas un indicateur, on le stocke.
      buffer_rx_cpt++;
      if (buffer_rx_cpt > 8) { debut_rx = false; }             // On vient de lire 8 caractères sans indicateur de fin de trame ! On laisse tomber car le buffer est dimensionné à 10 caractères.
    }                                                          // On n'a pas encore reçu l'indicateur de fin de trame. Donc, on jette le caractère reçu.
  }
// On a vidé le buffer de réception, ou l'on a reçu une trame complète.

// -----------------------------------------------------------
  if ((debut_rx == true) && (final_rx == true)) {
    debut_rx = false; final_rx = false;
    if (strlen(buffer_rx) == 3) {                              // "(S0x)" = 3 caractères attendus.
      if (buffer_rx[0] == 'S') {                               // 'S' =>  Sélection de la carte.
        if ((buffer_rx[2] >= '0') && (buffer_rx[2] <= '9')) {
          x = buffer_rx[2] - '0';
         if      (adresse_carte == 1) { if (x == 1) carte_valide = 1; else carte_valide = 0; }
         else if (adresse_carte == 2) { if (x == 2) carte_valide = 1; else carte_valide = 0; }
         else if (adresse_carte == 3) { if (x == 3) carte_valide = 1; else carte_valide = 0; }
         else if (adresse_carte == 4) { if (x == 4) carte_valide = 1; else carte_valide = 0; }
        }
      }
    }
// -----------------------------------------------------------    
    if ((strlen(buffer_rx) == 3) && (carte_valide == 1)) {     // "AXy" = 3 caractères attendus.
      if (buffer_rx[0] == 'A') {                               // 'A' =>
        if       (buffer_rx[1] == 'F') {                       // Feux blancs.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_blanc_1,   LOW);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_avant_blanc_2,   LOW);
          else if (buffer_rx[2] == '2' ) digitalWrite(SORTIE_arriere_blanc_1, LOW);
          else if (buffer_rx[2] == '3' ) digitalWrite(SORTIE_arriere_blanc_2, LOW);
          else if (buffer_rx[2] == '4' ) {
	  digitalWrite(SORTIE_avant_blanc_1, LOW); digitalWrite(SORTIE_arriere_blanc_1, LOW);    //  On allume les 4 feux.
	  digitalWrite(SORTIE_avant_blanc_2, LOW); digitalWrite(SORTIE_arriere_blanc_2, LOW); }
        }
        else if (buffer_rx[1] == 'J') {                        // Projecteur.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_proj_1,    LOW);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_avant_proj_2,    LOW);
          else if (buffer_rx[2] == '2' ) digitalWrite(SORTIE_arriere_proj_1,  LOW);
          else if (buffer_rx[2] == '3' ) digitalWrite(SORTIE_arriere_proj_2,  LOW);
        }
        else if (buffer_rx[1] == 'R') {                        // Feux rouges.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_rouge_1,   LOW);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_avant_rouge_2,   LOW);
          else if (buffer_rx[2] == '2' ) digitalWrite(SORTIE_arriere_rouge_2, LOW);
          else if (buffer_rx[2] == '3' ) digitalWrite(SORTIE_arriere_rouge_1, LOW);
        }
        else if (buffer_rx[1] == 'C') {                        // Cabines.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_plafond,   LOW);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_arriere_plafond, LOW);
        }
        else if (buffer_rx[1] == 'P') {                        // Pantographes.
          if      (buffer_rx[2] == '0' ) servo1_consigne = panto1_haut;
          else if (buffer_rx[2] == '1' ) servo2_consigne = panto2_haut;
        }
        else if (buffer_rx[1] == 'T') {                        // Tout
          digitalWrite(SORTIE_avant_blanc_1,   LOW); digitalWrite(SORTIE_avant_blanc_2,   LOW); digitalWrite(SORTIE_avant_proj_1,    LOW);
          digitalWrite(SORTIE_avant_proj_2,    LOW); digitalWrite(SORTIE_avant_rouge_1,   LOW); digitalWrite(SORTIE_avant_rouge_2,   LOW);
          digitalWrite(SORTIE_avant_plafond,   LOW); digitalWrite(SORTIE_arriere_blanc_1, LOW); digitalWrite(SORTIE_arriere_blanc_2, LOW);
          digitalWrite(SORTIE_arriere_proj_1,  LOW); digitalWrite(SORTIE_arriere_proj_2,  LOW); digitalWrite(SORTIE_arriere_rouge_1, LOW);
          digitalWrite(SORTIE_arriere_rouge_2, LOW); digitalWrite(SORTIE_arriere_plafond, LOW); servo1_consigne = panto1_haut; servo2_consigne = panto2_haut;
        }
      }
// -----------------------------------------------------------      
      else if (buffer_rx[0] == 'E') {                          // 'E' =>
        if       (buffer_rx[1] == 'F') {                       // Feux blancs.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_blanc_1,   HIGH);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_avant_blanc_2,   HIGH);
          else if (buffer_rx[2] == '2' ) digitalWrite(SORTIE_arriere_blanc_1, HIGH);
          else if (buffer_rx[2] == '3' ) digitalWrite(SORTIE_arriere_blanc_2, HIGH);
          else if (buffer_rx[2] == '4' ) {
	  digitalWrite(SORTIE_avant_blanc_1, HIGH); digitalWrite(SORTIE_arriere_blanc_1, HIGH); // On éteint les 4 feux et les 4 projecteurs.
	  digitalWrite(SORTIE_avant_blanc_2, HIGH); digitalWrite(SORTIE_arriere_blanc_2, HIGH);
	  digitalWrite(SORTIE_avant_proj_1, HIGH); digitalWrite(SORTIE_arriere_proj_1, HIGH);
	  digitalWrite(SORTIE_avant_proj_2, HIGH); digitalWrite(SORTIE_arriere_proj_2, HIGH); }
        }
        else if (buffer_rx[1] == 'J') {                         // Projecteur.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_proj_1,    HIGH);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_avant_proj_2,    HIGH);
          else if (buffer_rx[2] == '2' ) digitalWrite(SORTIE_arriere_proj_1,  HIGH);
          else if (buffer_rx[2] == '3' ) digitalWrite(SORTIE_arriere_proj_2,  HIGH);
        }
        else if (buffer_rx[1] == 'R') {                        // Feux rouges.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_rouge_1,   HIGH);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_avant_rouge_2,   HIGH);
          else if (buffer_rx[2] == '2' ) digitalWrite(SORTIE_arriere_rouge_2, HIGH);
          else if (buffer_rx[2] == '3' ) digitalWrite(SORTIE_arriere_rouge_1, HIGH);
        }
        else if (buffer_rx[1] == 'C') {                        // Cabines.
          if      (buffer_rx[2] == '0' ) digitalWrite(SORTIE_avant_plafond,   HIGH);
          else if (buffer_rx[2] == '1' ) digitalWrite(SORTIE_arriere_plafond, HIGH);
        }
        else if (buffer_rx[1] == 'C') {                        // Pantographes.
          if      (buffer_rx[2] == '0' ) servo1_consigne = panto1_bas;
          else if (buffer_rx[2] == '1' ) servo2_consigne = panto2_bas;
        }
        else if (buffer_rx[1] == 'T') {                        // Tout
          digitalWrite(SORTIE_avant_blanc_1,   HIGH); digitalWrite(SORTIE_avant_blanc_2,   HIGH); digitalWrite(SORTIE_avant_proj_1,    HIGH);
          digitalWrite(SORTIE_avant_proj_2,    HIGH); digitalWrite(SORTIE_avant_rouge_1,   HIGH); digitalWrite(SORTIE_avant_rouge_2,   HIGH);
          digitalWrite(SORTIE_avant_plafond,   HIGH); digitalWrite(SORTIE_arriere_blanc_1, HIGH); digitalWrite(SORTIE_arriere_blanc_2, HIGH);
          digitalWrite(SORTIE_arriere_proj_1,  HIGH); digitalWrite(SORTIE_arriere_proj_2,  HIGH); digitalWrite(SORTIE_arriere_rouge_1, HIGH);
          digitalWrite(SORTIE_arriere_rouge_2, HIGH); digitalWrite(SORTIE_arriere_plafond, HIGH); servo1_consigne = panto1_bas; servo2_consigne = panto2_bas;
        }
      }
// -----------------------------------------------------------
      else if (buffer_rx[0] == 'V') {                              // 'V' =>  Affiche la version.
        if (Serial.availableForWrite() > 0) Serial.write("[JLF_V2.0_18/01/2026]"); // Demande la version du programme.      
      }
    }
  }
// ------------------------------------------------------------------------------------------------------------------------------------
// Pour un mouvement lent des servomoteurs.
// #define panto_pas             10    // 10 µsec de pas. Minimum = 5 µsec, car les servomoteurs ne bougent pas si moins.
// #define panto_vitesse         20    // 20 msec entre chaque pas = Vitesse du panto. Minimum = 20 msec.
//
  if (servo1_val != servo1_consigne) {
    milli_actuel1 = millis();
    if (milli_actuel1 - milli_old1 > panto_vitesse) {
      milli_old1 = milli_actuel1;
      servomoteur1.writeMicroseconds(servo1_val);
      if (servo1_val < servo1_consigne) {
        servo1_val = servo1_val + panto_pas;
        if (servo1_val > servo1_consigne) servo1_val = servo1_consigne;
      }
      if (servo1_val > servo1_consigne) {
        servo1_val = servo1_val - panto_pas;
        if (servo1_val < servo1_consigne) servo1_val = servo1_consigne;
      }
    }
  }
  if (servo2_val != servo2_consigne) {
    milli_actuel2 = millis();
    if (milli_actuel2 - milli_old2 > panto_vitesse) {
      milli_old2 = milli_actuel2;
      servomoteur2.writeMicroseconds(servo2_val);
      if (servo2_val < servo2_consigne) {
        servo2_val = servo2_val + panto_pas;
        if (servo2_val > servo2_consigne) servo2_val = servo2_consigne;
      }
      if (servo2_val > servo2_consigne) {
        servo2_val = servo2_val - panto_pas;
        if (servo2_val < servo2_consigne) servo2_val = servo2_consigne;
      }
    }
  }
}
